 /****** Object:  UserDefinedFunction [dbo].[UFD_EST_NF_ENT_EXP_EF]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_NF_ENT_EXP_EF]') 
			AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_NF_ENT_EXP_EF]
GO
GO
GO
/****** Object:  UserDefinedFunction [dbo].[UFD_EST_NF_ENT_EXP_EF]    Script Date: 08/26/2011 08:51:56 ******/

/*
SELECT  
	*
FROM 
	UFD_EST_NF_ENT_EXP_EF(1,'85','2011-02-16','2011-02-16') where nr_nf = 695693
*/

CREATE FUNCTION [dbo].[UFD_EST_NF_ENT_EXP_EF](@CD_EMP		INT,
											 @CD_FILIAL		VARCHAR(4000),
											 @DT_INI 		DATETIME,
											 @DT_FIM        DATETIME)
RETURNS @RS_TMP TABLE (
			CD_EMP								INT,
			CD_FILIAL							INT,
			NM_FANT								VARCHAR(100),
			RZ_FORN								VARCHAR(100),
			CGC_CPF								VARCHAR(25),
			INSC_EST							VARCHAR(35),
			UF									VARCHAR(2),
			DT_ENT								DATETIME,
			DT_EMI_NF							DATETIME,
			CD_NF								INT,
			NR_NF								INT,
			ESP_NF								VARCHAR(15),
			SERIE_NF							VARCHAR(15),
			VLR_ICMS_NF							MONEY,
			VLR_BASE_ICMS_NF					MONEY,
			VLR_BASE_ICMS_SUBS_NF				MONEY,
			VLR_BASE_SUBS						MONEY,
			VLR_ICMS_SUBS						MONEY,
			CD_CTB_CNT							VARCHAR(30),
			VLR_TOT_PROD						MONEY,
			VLR_BASE_ICMS						MONEY,
			VLR_ICMS							MONEY,
			ALIQ_ICMS							MONEY,
			VLR_BASE_IPI						MONEY,
			VLR_IPI								MONEY,
			VLR_ISENTO							MONEY,
			VLR_OUTROS							MONEY,
			VLR_NF								MONEY,
			VLR_DIF								MONEY,
			CD_CFOP								INT,
			CFOP								VARCHAR(10),
			CD_ORIG								INT,
			VLR_NOTA							MONEY,
			CD_MOV_OP							INT,
			STS_NF								VARCHAR(15),
			CD_CTB_CNT_RED						INT,
			DEST_ORIG                           INT,
			TP_FORN								INT,
			VLR_FRETE							MONEY,
			VLR_DESC							MONEY,
			CD_SERIE							INT,
			POSSUI_PROD							INT,
			TP_LAYOUT_EXP_ENT                   INT,
			CD_NT_OP                            INT,
			PGTO_VISTA_PRAZO                    INT,
			OBS1								VARCHAR(300),
			TP_FRETE							INT,
			HR_EMI_NF							VARCHAR(50),
			VLR_OUTRAS_TAXAS					MONEY,
			CD_TP_FORN							INT,
			DS_TP							    VARCHAR(250),
			TP_MOV								INT,	
			DS_MOV_OP						    VARCHAR(250),
			NFE_CPL								INT,
			VLR_FECOP_ST                            MONEY,
			VLR_FECOP_RET                           MONEY)
AS
BEGIN
DECLARE @RS_EST_NF_TMP TABLE(
			CD_EMP								INT,
			CD_FILIAL							INT,
			NM_FANT								VARCHAR(100),
			RZ_FORN								VARCHAR(100),
			CGC_CPF								VARCHAR(25),
			INSC_EST							VARCHAR(35),
			UF									VARCHAR(2),
			DT_ENT								DATETIME,
			DT_EMI_NF							DATETIME,
			CD_NF								INT,
			NR_NF								INT,
			ESP_NF								VARCHAR(15),
			SERIE_NF							VARCHAR(15),
			VLR_ICMS_NF							MONEY,
			VLR_BASE_ICMS_NF					MONEY,
			VLR_BASE_ICMS_SUBS_NF				MONEY,
			VLR_BASE_SUBS						MONEY,
			VLR_ICMS_SUBS						MONEY,
			CD_CTB_CNT							VARCHAR(30),
			VLR_TOT_PROD						MONEY,
			VLR_BASE_ICMS						MONEY,
			VLR_ICMS							MONEY,
			ALIQ_ICMS							MONEY,
			VLR_BASE_IPI						MONEY,
			VLR_IPI								MONEY,
			VLR_ISENTO							MONEY,
			VLR_OUTROS							MONEY,
			VLR_NF								MONEY,
			VLR_DIF								MONEY,
			CD_CFOP								INT,
			CFOP								VARCHAR(10),
			CD_ORIG								INT,
			VLR_NOTA							MONEY,
			CD_MOV_OP							INT,
			STS_NF								VARCHAR(15),
			CD_CTB_CNT_RED						INT,
			DEST_ORIG                           INT,
			TP_FORN								INT,
			VLR_FRETE							MONEY,
			VLR_DESC							MONEY,
			CD_SERIE							INT,
			POSSUI_PROD							INT,
            TP_LAYOUT_EXP_ENT                   INT,
			CD_NT_OP                            INT,
			PGTO_VISTA_PRAZO                    INT,
			OBS1								VARCHAR(300),
			TP_FRETE							INT,
			HR_EMI_NF							VARCHAR(50),
			VLR_OUTRAS_TAXAS					MONEY,
			CD_TP_FORN							INT,
			DS_TP							    VARCHAR(250),
			TP_MOV								INT,
			DS_MOV_OP						    VARCHAR(250),
			NFE_CPL								INT,
			VLR_FECOP_ST                            MONEY,
			VLR_FECOP_RET                           MONEY)

--Notas ficais com Icms normal
DECLARE @RS_EST_NF_ICMS TABLE(
			CD_EMP								INT,
			CD_FILIAL							INT,
			CD_NF								INT,
			VLR_TOT_PROD						MONEY,
			VLR_NOTA							MONEY)


--Notas ficais de fornecedores
DECLARE @RS_EST_NF_FORNECEDOR TABLE(
			CD_EMP								INT,
			CD_FILIAL							INT,
			CD_NF								INT,
			CD_ORIG								INT,			
			TP_FORN							    INT,
            TP_LAYOUT_EXP_ENT                   INT)



/*--Notas ficais com Icms normal pago anteriormente
DECLARE @RS_EST_NF_ICMS_PAGO_ANT TABLE(
			CD_EMP								INT,
			CD_FILIAL							INT,
			CD_NF									INT,
			VLR_TOT_PROD						MONEY)*/

--Notas ficais com ipi para achar a base de calculo
DECLARE @RS_EST_NF_BASE_IPI TABLE(
			CD_EMP								INT,
			CD_FILIAL							INT,
			CD_NF								INT,
			VLR_BASE_IPI						MONEY)

--Notas ficais com Base de Icms normal refazer lancto
--Pois o usurio deixa entrar a informao incorreto devido
-- ao arredondamento
	DECLARE @RS_EST_NF_BASE_ICMS TABLE(
			CD_EMP								INT,
			CD_FILIAL							INT,
			CD_NF								INT)

	DECLARE @TBL_FILIAL TABLE (CD_EMP INT, CD_FILIAL INT)
	INSERT INTO @TBL_FILIAL 
	SELECT
		CD_EMP,
		CD_FILIAL
	FROM PRC_FILIAL 
	WHERE CD_EMP = @CD_EMP
		AND CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))

--Notas ficais com ipi para achar a base de calculo
INSERT INTO @RS_EST_NF_BASE_IPI
			(CD_EMP,
			CD_FILIAL,
			CD_NF,
			VLR_BASE_IPI)
		SELECT 
			V_EST_NF_ENT.CD_EMP,
			V_EST_NF_ENT.CD_FILIAL,
			V_EST_NF_ENT.CD_NF,
			SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2))
		FROM 
			V_EST_NF_ENT
			INNER JOIN @TBL_FILIAL FL ON
			V_EST_NF_ENT.CD_EMP = FL.CD_EMP AND
			V_EST_NF_ENT.CD_FILIAL = FL.CD_FILIAL 

		WHERE 
			V_EST_NF_ENT.CD_EMP = @CD_EMP 
			AND V_EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
			AND V_EST_NF_ENT.VLR_IPI_IT  > 0
	GROUP BY
			V_EST_NF_ENT.CD_EMP,
			V_EST_NF_ENT.CD_FILIAL,
			V_EST_NF_ENT.CD_NF,
			V_EST_NF_ENT.PGTO_VISTA_PRAZO,
			V_EST_NF_ENT.TP_FRETE,
			V_EST_NF_ENT.HR_EMI_NF

	INSERT INTO @RS_EST_NF_TMP
	SELECT          
		V_EST_NF_ENT.CD_EMP, 
		V_EST_NF_ENT.CD_FILIAL, 
		PRC_FILIAL.NM_FANT,
		V_EST_NF_ENT.NM_ORIG AS RZ_FORN, 
		V_EST_NF_ENT.CGC_CPF, 
		V_EST_NF_ENT.INSC_EST,
		V_EST_NF_ENT.UF, 
	    V_EST_NF_ENT.DT_ENT, 
		V_EST_NF_ENT.DT_EMI_NF, 
		V_EST_NF_ENT.CD_NF, 
		V_EST_NF_ENT.NR_NF, 		
		EST_NF_SERIE.ESPC AS ESP_NF, 
	    EST_NF_SERIE.SERIE AS SERIE_NF, 
	    VLR_ICMS_NF = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
								V_EST_NF_ENT.VLR_ICMS
						  ELSE
								0
						  END,
	    VLR_BASE_ICMS_NF = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
									V_EST_NF_ENT.VLR_BASE_ICMS
								ELSE
									0
								END, 
	    VLR_BASE_ICMS_SUBS_NF = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
											CASE WHEN SUM(V_EST_NF_ENT.VLR_BASE_SUBS_IT) > 0 THEN
												SUM(ROUND( V_EST_NF_ENT.VLR_BASE_SUBS_IT,2))
											ELSE
												0
											END
										ELSE		
											0
										END,
		VLR_BASE_SUBS= CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
							CASE WHEN V_EST_NF_ENT.SUBS_TRIB = 1 THEN
								SUM(DISTINCT V_EST_NF_ENT.VLR_BASE_ICMS_SUBS)
							ELSE
								0
							END								
					   ELSE
								0
					   END,
		VLR_ICMS_SUBS= CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
							CASE WHEN V_EST_NF_ENT.SUBS_TRIB = 1 THEN
								SUM(ROUND( V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2))
							ELSE
								0
							END								
					    ELSE
								0
						END,
		CD_CTB_CNT, 
		VLR_TOT_PROD = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
								SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2))
							ELSE
									0
							END,
		VLR_BASE_ICMS =CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN 
								CASE WHEN V_EST_NF_ENT.ICMS = 1 THEN
									  SUM(ROUND(V_EST_NF_ENT.VLR_BASE_ICMS_IT,2))
								WHEN V_EST_NF_ENT.ICMS_RD = 1 THEN
									SUM(ROUND(V_EST_NF_ENT.VLR_BASE_ICMS_IT,2)) 								 
								 ELSE
									   0
								 END
							ELSE
								0
							END,
		VLR_ICMS =  CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
									CASE WHEN V_EST_NF_ENT.ICMS = 1 THEN
										SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_IT,2))
									WHEN V_EST_NF_ENT.ICMS_RD = 1 THEN
										SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_IT,2)) 								 									
									ELSE
										0
									END
						ELSE
							0						
						END,
		ALIQ_ICMS = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
							CASE WHEN V_EST_NF_ENT.ICMS = 1 THEN
									V_EST_NF_ENT.ALIQ_ICMS
							WHEN V_EST_NF_ENT.ICMS_RD = 1 THEN
									V_EST_NF_ENT.ALIQ_ICMS
							 ELSE
								  0
							 END
						ELSE
							0
						END,
		VLR_BASE_IPI =  CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
							CASE WHEN SUM(V_EST_NF_ENT.VLR_IPI_IT)> 0 THEN
								ISNULL(BASE_IPI.VLR_BASE_IPI,0)
							ELSE
								0
							END
					 ELSE
							0
					 END,	
		VLR_IPI = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
							SUM(V_EST_NF_ENT.VLR_IPI_IT)
					 ELSE
							0
					 END,	
		VLR_ISENTO = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN 
							CASE WHEN V_EST_NF_ENT.ISENTO=1 THEN
								SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2))
							ELSE
								0
							END
						ELSE
							0
						END,
VLR_OUTROS =CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN 
			CASE WHEN V_EST_NF_ENT.SUBS_TRIB = 1 THEN
				CASE WHEN SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)  > 0 THEN
					SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(V_EST_NF_ENT.VLR_ICMS_RET) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS) 
				ELSE
					0
				END 
			WHEN V_EST_NF_ENT.ICMS=1 THEN
				CASE WHEN SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(V_EST_NF_ENT.VLR_ICMS_RET) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)  > 0 THEN
					SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS) 
				ELSE
					0
				END 
			WHEN V_EST_NF_ENT.SUBS_TRIB_ANT = 1 OR V_EST_NF_ENT.FLAG_OUTROS = 1  THEN
				CASE WHEN SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)  > 0 THEN
					SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)
				ELSE
					0
				END 
			WHEN V_EST_NF_ENT.ICMS_RD = 1 THEN
				CASE WHEN SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)  > 0 THEN
					SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS) 
				ELSE
					0
				END 
			ELSE
				0
			END
		ELSE
			0
		END,
	VLR_NF =CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN 
			CASE WHEN V_EST_NF_ENT.ICMS = 1 THEN
				SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)
			WHEN V_EST_NF_ENT.SUBS_TRIB = 1 THEN
				SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)
			WHEN V_EST_NF_ENT.SUBS_TRIB_ANT = 1 OR V_EST_NF_ENT.FLAG_OUTROS = 1 THEN
				SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)
			WHEN V_EST_NF_ENT.ICMS_RD = 1 THEN
				SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) + SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)
			WHEN V_EST_NF_ENT.ISENTO=1 THEN
				CASE WHEN  SUM(V_EST_NF_ENT.VLR_TOT_IT)<>SUM(ROUND(V_EST_NF_ENT.VLR_BASE_ICMS_IT,2)) THEN
					SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)+ SUM(CASE WHEN V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR= 0 THEN V_EST_NF_ENT.VLR_ICMS_RET ELSE 0 END) - SUM(ROUND(V_EST_NF_ENT.VLR_ICMS_SUBS_IT,2)) + SUM(VLR_OUTRAS_DESPESAS)
				ELSE
					SUM(ROUND(V_EST_NF_ENT.VLR_TOT_IT,2)) + SUM(V_EST_NF_ENT.VLR_IPI_IT  + V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO)
				END
			ELSE
				0
			END
		ELSE
			0
		END, 
		0,
		V_EST_NF_ENT.CD_NT_OP,
		V_EST_NF_ENT.CFOP,
		CD_ORIG = CASE WHEN DEST_ORIG = 2 THEN
						ISNULL((SELECT
							PRC_FILIAL_RC_CLI.CD_CLI
						FROM
							PRC_FILIAL INNER JOIN PRC_FILIAL_RC_CLI ON
							PRC_FILIAL.CD_EMP = PRC_FILIAL_RC_CLI.CD_EMP AND
							PRC_FILIAL.CD_FILIAL = PRC_FILIAL_RC_CLI.CD_FILIAL
						WHERE
							PRC_FILIAL.CD_EMP = V_EST_NF_ENT.CD_EMP
							AND PRC_FILIAL.CD_FILIAL = V_EST_NF_ENT.CD_ORIG),0)
					 ELSE
						CD_ORIG
					 END,
		VLR_NOTA = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
							V_EST_NF_ENT.VLR_NF 
						ELSE
							0
						END,
		V_EST_NF_ENT.CD_MOV_OP,
		STS_NF = CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN
						''
					ELSE
						'CANCELADA'
					END,
		CD_CTB_CNT_RED,
		V_EST_NF_ENT.DEST_ORIG,
		TP_FORN=0,
		VLR_FRETE,
		SUM(VLR_DESC_IT),
		V_EST_NF_ENT.CD_NF_SERIE,
		0,
        0,
		V_EST_NF_ENT.CD_NT_OP,
		V_EST_NF_ENT.PGTO_VISTA_PRAZO,
		V_EST_NF_ENT.OBS1,
		V_EST_NF_ENT.TP_FRETE,
		V_EST_NF_ENT.HR_EMI_NF,
		VLR_OUTROS AS VLR_OUTROS_TAXAS,
		V_EST_NF_ENT.CD_TP_FORN,
		TIPO_FORNECEDOR,
		TP_MOV,
		V_EST_NF_ENT.DS_MOV_OP,
		V_EST_NF_ENT.FLAG_MOV_OP_NFE_CPL  --  SELECT TOP 1 * FROM V_EST_NF_ENT
		,VLR_FECOP_ST
		,VLR_FECOP_ST_RET AS VLR_FECOP_RET
	FROM         
		V_EST_NF_ENT 
		INNER JOIN EST_NF_SERIE ON 
		V_EST_NF_ENT.CD_EMP = EST_NF_SERIE.CD_EMP AND 
		V_EST_NF_ENT.CD_NF_SERIE = EST_NF_SERIE.CD_NF_SERIE
		INNER JOIN PRC_FILIAL ON
		V_EST_NF_ENT.CD_EMP = PRC_FILIAL.CD_EMP AND
		V_EST_NF_ENT.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
		INNER JOIN @TBL_FILIAL FL ON
		V_EST_NF_ENT.CD_EMP = FL.CD_EMP AND
		V_EST_NF_ENT.CD_FILIAL = FL.CD_FILIAL 
		LEFT OUTER JOIN @RS_EST_NF_BASE_IPI BASE_IPI ON
		V_EST_NF_ENT.CD_EMP = BASE_IPI.CD_EMP		AND
		V_EST_NF_ENT.CD_FILIAL = BASE_IPI.CD_FILIAL AND
		V_EST_NF_ENT.CD_NF = BASE_IPI.CD_NF
	WHERE 
		V_EST_NF_ENT.CD_EMP = @CD_EMP 
		AND V_EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
	GROUP BY 
		V_EST_NF_ENT.CD_EMP, 
		V_EST_NF_ENT.CD_FILIAL, 
		PRC_FILIAL.NM_FANT,
		V_EST_NF_ENT.NM_ORIG, 
		V_EST_NF_ENT.CGC_CPF, 
		V_EST_NF_ENT.INSC_EST,
		V_EST_NF_ENT.UF, 
	  	V_EST_NF_ENT.DT_ENT, 
		V_EST_NF_ENT.DT_EMI_NF, 
		V_EST_NF_ENT.NR_NF,
		V_EST_NF_ENT.VLR_ICMS,
		V_EST_NF_ENT.VLR_BASE_ICMS,
		V_EST_NF_ENT.ALIQ_ICMS,
		V_EST_NF_ENT.CD_NF,
		EST_NF_SERIE.ESPC, 
		EST_NF_SERIE.SERIE, 
		V_EST_NF_ENT.CD_NT_OP,
		V_EST_NF_ENT.CFOP,
		V_EST_NF_ENT.CD_ORIG,
		V_EST_NF_ENT.VLR_NF,
		V_EST_NF_ENT.CD_MOV_OP,
		V_EST_NF_ENT.STS_NF,
		V_EST_NF_ENT.CD_CTB_CNT_RED,
		V_EST_NF_ENT.CD_CTB_CNT,
		V_EST_NF_ENT.DEST_ORIG,
		BASE_IPI.VLR_BASE_IPI,
		V_EST_NF_ENT.VLR_FRETE,
		V_EST_NF_ENT.CD_NF_SERIE,
		V_EST_NF_ENT.CD_NT_OP,
		V_EST_NF_ENT.PGTO_VISTA_PRAZO,
		V_EST_NF_ENT.OBS1,
		V_EST_NF_ENT.TP_FRETE,
		V_EST_NF_ENT.HR_EMI_NF,
		V_EST_NF_ENT.ICMS,
		V_EST_NF_ENT.SUBS_TRIB,
		V_EST_NF_ENT.ICMS_RD,
		V_EST_NF_ENT.SUBS_TRIB_ANT,
		V_EST_NF_ENT.ISENTO,
		V_EST_NF_ENT.VLR_OUTROS,
		V_EST_NF_ENT.CD_TP_FORN,
		V_EST_NF_ENT.TIPO_FORNECEDOR,
		TP_MOV,
		V_EST_NF_ENT.ALIQ_ICMS,
		V_EST_NF_ENT.DS_MOV_OP,
		V_EST_NF_ENT.FLAG_MOV_OP_NFE_CPL,
		V_EST_NF_ENT.FLAG_ICMS_SUBST_PAGO_ANTERIOR,
		V_EST_NF_ENT.FLAG_OUTROS
		,VLR_FECOP_ST
		,VLR_FECOP_ST_RET

	INSERT INTO @RS_EST_NF_FORNECEDOR
	SELECT 
		RS_NF_TEMP.CD_EMP,
		RS_NF_TEMP.CD_FILIAL,
		RS_NF_TEMP.CD_NF,
		RS_NF_TEMP.CD_ORIG,
		CASE WHEN ISNULL(PG_TP_FORN.TP_FORN,99)=99 THEN 99 ELSE PG_TP_FORN.TP_FORN END AS TP_FORN,
		PG_FORN.TP_LAYOUT_EXP_ENT
	FROM        
		@RS_EST_NF_TMP AS RS_NF_TEMP 
		INNER JOIN	PG_FORN ON 
		RS_NF_TEMP.CD_EMP = PG_FORN.CD_EMP AND 
		RS_NF_TEMP.CD_ORIG = PG_FORN.CD_FORN 
		INNER JOIN	PG_TP_FORN ON 
		PG_TP_FORN.CD_EMP = PG_FORN.CD_EMP AND 
		PG_TP_FORN.CD_TP_FORN = PG_FORN.CD_TP_FORN			
	WHERE
		RS_NF_TEMP.DEST_ORIG=1
		
--Alterando o tipo de fornecedores
	UPDATE 
		@RS_EST_NF_TMP
	SET
		TP_FORN =  RS_EST_NF_FORNECEDOR.TP_FORN,
		TP_LAYOUT_EXP_ENT = RS_EST_NF_FORNECEDOR.TP_LAYOUT_EXP_ENT
	FROM
		@RS_EST_NF_FORNECEDOR AS RS_EST_NF_FORNECEDOR,
		@RS_EST_NF_TMP AS RS_EST_NF_TMP
	WHERE
		RS_EST_NF_TMP.CD_EMP	= RS_EST_NF_FORNECEDOR.CD_EMP	AND
		RS_EST_NF_TMP.CD_FILIAL = RS_EST_NF_FORNECEDOR.CD_FILIAL AND
		RS_EST_NF_TMP.CD_NF = RS_EST_NF_FORNECEDOR.CD_NF AND
		RS_EST_NF_TMP.CD_ORIG = RS_EST_NF_FORNECEDOR.CD_ORIG

	INSERT INTO @RS_TMP 
	SELECT 
		CD_EMP,
		CD_FILIAL,
		NM_FANT,
		RZ_FORN,
		CGC_CPF,
		INSC_EST,
		UF,
		DT_ENT,
		DT_EMI_NF,
		CD_NF,
		NR_NF,
		ESP_NF,
		SERIE_NF,
		VLR_ICMS_NF,
		VLR_BASE_ICMS_NF,
		SUM(DISTINCT VLR_BASE_ICMS_SUBS_NF),
		SUM(VLR_BASE_SUBS),
		SUM(VLR_ICMS_SUBS),
		CD_CTB_CNT,
		SUM(VLR_TOT_PROD),
		SUM(VLR_BASE_ICMS),
		(SUM(VLR_BASE_ICMS) * ALIQ_ICMS) / 100,
		ALIQ_ICMS,
		SUM(VLR_BASE_IPI),
		SUM(VLR_IPI),
		SUM(VLR_ISENTO),
		SUM(VLR_OUTROS),
		SUM(VLR_NF),
		CASE WHEN SUM(VLR_BASE_SUBS) = 0 THEN
			SUM(VLR_NF) - (SUM(VLR_BASE_ICMS) + SUM(VLR_OUTROS) + SUM(VLR_IPI) + SUM(VLR_ISENTO)) 
		ELSE
			SUM(VLR_NF) - (SUM(VLR_TOT_PROD) + SUM(VLR_ICMS_SUBS) + SUM(VLR_IPI)) 
		END,
		CD_CFOP,
		CFOP,
		CD_ORIG,
		VLR_NOTA,
		CD_MOV_OP,
		STS_NF,
		CD_CTB_CNT_RED,
		DEST_ORIG,
		TP_FORN,
		VLR_FRETE,
		SUM(VLR_DESC),
		CD_SERIE,
		POSSUI_PROD,
        TP_LAYOUT_EXP_ENT,
		CD_NT_OP,
		PGTO_VISTA_PRAZO,
	    OBS1,
		TP_FRETE,
	    HR_EMI_NF,
		VLR_OUTRAS_TAXAS,
		CD_TP_FORN,
		DS_TP,
		TP_MOV,
		DS_MOV_OP,
		NFE_CPL,
		VLR_FECOP_ST ,
		VLR_FECOP_RET
	FROM 
		@RS_EST_NF_TMP
	GROUP BY
		CD_EMP,
		CD_FILIAL,
		NM_FANT,
		RZ_FORN,
		CGC_CPF,
		INSC_EST,
		UF,
		DT_ENT,
		DT_EMI_NF,
		CD_NF,
		NR_NF,
		ESP_NF,
		SERIE_NF,
		VLR_ICMS_NF,
		VLR_BASE_ICMS_NF,
		CD_CTB_CNT,
		CD_CFOP,
		CFOP,
		CD_ORIG,
		VLR_NOTA,
		CD_MOV_OP,
		STS_NF,
		CD_CTB_CNT_RED,
		CD_CTB_CNT,
		DEST_ORIG,
		TP_FORN,
		VLR_FRETE,
		CD_SERIE,
		POSSUI_PROD,
		TP_LAYOUT_EXP_ENT,
		CD_NT_OP,
		PGTO_VISTA_PRAZO,
	    OBS1,
		TP_FRETE,
	    HR_EMI_NF,
		VLR_OUTRAS_TAXAS,
		CD_TP_FORN,
		DS_TP,
		TP_MOV,
		ALIQ_ICMS, 
		DS_MOV_OP,
		NFE_CPL,
		VLR_FECOP_ST ,
		VLR_FECOP_RET

--Pegando Notas fiscais sem produtos
	INSERT INTO @RS_TMP 
	SELECT     
		EST_NF_ENT.CD_EMP, 
		EST_NF_ENT.CD_FILIAL, 
		PRC_FILIAL.NM_FANT, 
		CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN
		  (SELECT     RZ_FORN
			FROM          PG_FORN
			WHERE      PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN) 
		WHEN GLB_MOV_OP.DEST_ORIG = 2 THEN
		  (SELECT     RZ_FILIAL
			FROM          PRC_FILIAL
			WHERE      PRC_FILIAL.CD_EMP = EST_NF_ENT.CD_EMP AND PRC_FILIAL.CD_FILIAL = EST_NF_ENT.CD_FORN) 
		WHEN GLB_MOV_OP.DEST_ORIG = 0 THEN
		  (SELECT     RZ_CLI
			FROM          RC_CLI
			WHERE      RC_CLI.CD_EMP = EST_NF_ENT.CD_EMP AND RC_CLI.CD_CLI = EST_NF_ENT.CD_FORN) 
		ELSE 'SEM CLASSIFICAAO DESTINATARIO' END AS RZ_FORN,
		CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN
								  (SELECT     CGC_CPF
									FROM          PG_FORN
									WHERE      PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN) 
							  WHEN  GLB_MOV_OP.DEST_ORIG = 2 THEN
								  (SELECT     CGC
									FROM          PRC_FILIAL
									WHERE      PRC_FILIAL.CD_EMP = EST_NF_ENT.CD_EMP AND PRC_FILIAL.CD_FILIAL = EST_NF_ENT.CD_FORN) 
							  WHEN GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 AND GLB_MOV_OP.DEST_ORIG = 0 THEN
								  (SELECT     CGC_CPF
									FROM          RC_CLI
									WHERE      RC_CLI.CD_EMP = EST_NF_ENT.CD_EMP AND RC_CLI.CD_CLI = EST_NF_ENT.CD_FORN) 
							  ELSE 'SEM CLASSIFICAAO DESTINATARIO' END AS CGC_CPF,
		CASE WHEN  GLB_MOV_OP.DEST_ORIG = 1 THEN
								  (SELECT     INSC_EST
									FROM          PG_FORN
									WHERE      PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN) 
							  WHEN GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 AND GLB_MOV_OP.DEST_ORIG = 2 THEN
								  (SELECT     INSC_EST
									FROM          PRC_FILIAL
									WHERE      PRC_FILIAL.CD_EMP = EST_NF_ENT.CD_EMP AND PRC_FILIAL.CD_FILIAL = EST_NF_ENT.CD_FORN) 
							  WHEN GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 AND GLB_MOV_OP.DEST_ORIG = 0 THEN
								  (SELECT     INSC_EST
									FROM          RC_CLI
									WHERE      RC_CLI.CD_EMP = EST_NF_ENT.CD_EMP AND RC_CLI.CD_CLI = EST_NF_ENT.CD_FORN) 
							  ELSE 'SEM CLASSIFICAAO DESTINATARIO' END AS INSC_EST,	
		CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN
								  (SELECT     UF
									FROM          PG_FORN, GLB_CID
									WHERE      PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN AND 
														   PG_FORN.CD_CID = GLB_CID.CD_CID) WHEN GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 AND 
							  GLB_MOV_OP.DEST_ORIG = 2 THEN
								  (SELECT     UF
									FROM          PRC_FILIAL, GLB_CID
									WHERE      PRC_FILIAL.CD_EMP = EST_NF_ENT.CD_EMP AND PRC_FILIAL.CD_FILIAL = EST_NF_ENT.CD_FORN AND 
														   PRC_FILIAL.CD_CID = GLB_CID.CD_CID) WHEN GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 AND 
							  GLB_MOV_OP.DEST_ORIG = 0 THEN
								  (SELECT     UF
									FROM          RC_CLI, GLB_CID
									WHERE      RC_CLI.CD_EMP = EST_NF_ENT.CD_EMP AND RC_CLI.CD_CLI = EST_NF_ENT.CD_FORN AND RC_CLI.CD_CID = GLB_CID.CD_CID) 
							  ELSE 'SEM CLASSIFICAAO DESTINATARIO' END AS UF,	 
		EST_NF_ENT.DT_ENT, 
		EST_NF_ENT.DT_EMI_NF, 
		EST_NF_ENT.CD_NF, 
		EST_NF_ENT.NR_NF, 
		EST_NF_SERIE.ESPC, 
		EST_NF_SERIE.SERIE, 
		EST_NF_ENT.VLR_ICMS AS VLR_ICMS_NF, 
		EST_NF_ENT.VLR_BASE_ICMS AS VLR_BASE_ICMS_NF, 
		EST_NF_ENT.VLR_BASE_ICMS_SUBS AS VLR_BASE_ICMS_SUBS_NF, 
		EST_NF_ENT.VLR_BASE_ICMS_SUBS, 
		EST_NF_ENT.VLR_ICMS_SUBS, 
		GLB_NT_OP.CD_CTB_CNT, 
		EST_NF_ENT.VLR_TOT_PROD, 
		EST_NF_ENT.VLR_BASE_ICMS,
		EST_NF_ENT.VLR_ICMS,
		EST_NF_ENT.ALIQ_ICMS, 
		0 AS VLR_BASE_IPI,
		EST_NF_ENT.VLR_IPI, 
		EST_NF_ENT.VRL_ISENTAS, 
		EST_NF_ENT.VLR_OUTROS, 
		EST_NF_ENT.VLR_NF, 
		0,
		EST_NF_ENT.CD_NT_OP, 
		GLB_NT_OP.CD_NT_OP_FC AS CFOP, 
		EST_NF_ENT.CD_FORN AS CD_ORIG, 
		EST_NF_ENT.VLR_NF AS VLR_NOTA, 
		EST_NF_ENT.CD_NT_MOV AS CD_MOV_OP, 
		STS_NF = CASE WHEN EST_NF_ENT.STS_NF = 0 THEN
						''
					ELSE
						'CANCELADA'
					END,
		GLB_NT_OP.CD_CTB_CNT_RED,
		GLB_MOV_OP.DEST_ORIG,
		CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN
							(SELECT CASE WHEN ISNULL(PG_TP_FORN.TP_FORN,99)=99 THEN 
										99 
									ELSE 
										PG_TP_FORN.TP_FORN 
									END AS TP_FORN
							FROM        PG_TP_FORN, PG_FORN
							WHERE       PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND 
										PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN AND 
										PG_TP_FORN.CD_EMP = PG_FORN.CD_EMP AND 
										PG_TP_FORN.CD_TP_FORN = PG_FORN.CD_TP_FORN)
		WHEN GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 AND  GLB_MOV_OP.DEST_ORIG = 2 THEN
							99
		WHEN GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 AND GLB_MOV_OP.DEST_ORIG = 0 THEN
							99
		ELSE 99 END AS TP_FORN,
				VLR_FRETE,
				VLR_DESC,
				EST_NF_ENT.CD_NF_SERIE,
				1,
		(CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN
							(SELECT ISNULL(PG_FORN.TP_LAYOUT_EXP_ENT,0)
							 FROM PG_FORN
							 WHERE PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND 
								   PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN)
		ELSE 0
		END) AS TP_LAYOUT_EXP_ENT,
	EST_NF_ENT.CD_NT_OP,
	EST_NF_ENT.PGTO_VISTA_PRAZO,
	'',
    0,
	EST_NF_ENT.HR_EMI_NF,
	0 AS VLR_OUTROS_TAXAS,
	CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN
			(SELECT     CD_TP_FORN
			FROM          PG_FORN
			WHERE      
				PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND 
				PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN)
	ELSE
		0
	END AS CD_TP_FORN,
	CASE WHEN GLB_MOV_OP.DEST_ORIG = 1 THEN
			(SELECT     DS_TP
			FROM          PG_FORN, PG_TP_FORN
			WHERE      
				PG_FORN.CD_EMP = EST_NF_ENT.CD_EMP AND 
				PG_FORN.CD_FORN = EST_NF_ENT.CD_FORN AND 
				PG_FORN.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN)
		WHEN GLB_MOV_OP.DEST_ORIG = 2 THEN
				'FILIAIS'
		WHEN GLB_MOV_OP.DEST_ORIG = 0 THEN
			CASE WHEN ISNULL(PRC_FILIAL.CD_FILIAL,0) > 0 THEN
				'FILIAL'
			ELSE
				'CLIENTES'
			END				
		END AS TIPO_FORNECEDOR,
		TP_MOV,
		DS_MOV_OP,
		0
		,VLR_FECOP_ST
		,VLR_FECOP_ST_RET
	FROM         
		EST_NF_ENT 
		INNER JOIN EST_NF_SERIE ON 
		EST_NF_ENT.CD_EMP = EST_NF_SERIE.CD_EMP AND 
		EST_NF_ENT.CD_NF_SERIE = EST_NF_SERIE.CD_NF_SERIE 
		INNER JOIN GLB_NT_OP ON 
		EST_NF_ENT.CD_NT_OP = GLB_NT_OP.CD_NT_OP
		INNER JOIN @TBL_FILIAL FL ON
		EST_NF_ENT.CD_EMP = FL.CD_EMP AND
		EST_NF_ENT.CD_FILIAL = FL.CD_FILIAL 

		INNER JOIN PRC_FILIAL ON
		EST_NF_ENT.CD_EMP = PRC_FILIAL.CD_EMP AND
		EST_NF_ENT.CD_FILIAL = PRC_FILIAL.CD_FILIAL

		INNER JOIN GLB_MOV_OP ON
		EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
	WHERE
		EST_NF_ENT.CD_EMP = @CD_EMP 
		AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
		AND NOT EXISTS(SELECT 
							CD_EMP 
					  FROM
							PG_FORN
					  WHERE
							EST_NF_ENT.CD_EMP = PG_FORN.CD_EMP AND
							EST_NF_ENT.CD_FORN = PG_FORN.CD_FORN AND
							PG_FORN.EXPORT_NF_ESCRITA=1)

--Acerto nota fiscal total
UPDATE
	rr
SET
	rr.VLR_NOTA = r.VLR_NF
FROM
(SELECT
	CD_EMP,
	CD_FILIAL,
	CD_NF,
	SUM(VLR_NF) VLR_NF
FROM
	@RS_TMP
GROUP BY
	CD_EMP,
	CD_FILIAL,
	CD_NF) r INNER JOIN @RS_TMP rr ON
	r.CD_EMP = rr.CD_EMP AND
	r.CD_FILIAL = rr.CD_FILIAL AND
	r.CD_NF = rr.CD_NF
WHERE
	rr.VLR_NOTA <> r.VLR_NF
RETURN
END

GO


